// React Imports
import type { SVGAttributes } from 'react'

const Document = (props: SVGAttributes<SVGElement>) => {
  return (
    <svg xmlns='http://www.w3.org/2000/svg' width='64' height='65' viewBox='0 0 64 65' fill='none' {...props}>
      <path
        opacity='0.2'
        d='M55.875 14.6943H8.125C6.95139 14.6943 6 15.6457 6 16.8193V48.5693C6 49.7429 6.95139 50.6943 8.125 50.6943H55.875C57.0486 50.6943 58 49.7429 58 48.5693V16.8193C58 15.6457 57.0486 14.6943 55.875 14.6943Z'
        fill='currentColor'
      />
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M7 16.8193C7 16.198 7.50368 15.6943 8.125 15.6943H55.875C56.4963 15.6943 57 16.198 57 16.8193V48.5693C57 49.1907 56.4963 49.6943 55.875 49.6943H8.125C7.50368 49.6943 7 49.1907 7 48.5693V16.8193ZM8.125 13.6943C6.39911 13.6943 5 15.0934 5 16.8193V48.5693C5 50.2952 6.39911 51.6943 8.125 51.6943H55.875C57.6009 51.6943 59 50.2952 59 48.5693V16.8193C59 15.0934 57.6009 13.6943 55.875 13.6943H8.125ZM14 23.6943C13.4477 23.6943 13 24.1421 13 24.6943C13 25.2466 13.4477 25.6943 14 25.6943H50C50.5523 25.6943 51 25.2466 51 24.6943C51 24.1421 50.5523 23.6943 50 23.6943H14ZM14 31.6943C13.4477 31.6943 13 32.1421 13 32.6943C13 33.2466 13.4477 33.6943 14 33.6943H50C50.5523 33.6943 51 33.2466 51 32.6943C51 32.1421 50.5523 31.6943 50 31.6943H14ZM13 40.6943C13 40.1421 13.4477 39.6943 14 39.6943H16C16.5523 39.6943 17 40.1421 17 40.6943C17 41.2466 16.5523 41.6943 16 41.6943H14C13.4477 41.6943 13 41.2466 13 40.6943ZM24 39.6943C23.4477 39.6943 23 40.1421 23 40.6943C23 41.2466 23.4477 41.6943 24 41.6943H40C40.5523 41.6943 41 41.2466 41 40.6943C41 40.1421 40.5523 39.6943 40 39.6943H24ZM47 40.6943C47 40.1421 47.4477 39.6943 48 39.6943H50C50.5523 39.6943 51 40.1421 51 40.6943C51 41.2466 50.5523 41.6943 50 41.6943H48C47.4477 41.6943 47 41.2466 47 40.6943Z'
        fill='currentColor'
      />
    </svg>
  )
}

export default Document
